package edu.uky.ai.lp.logic;

/**
 * Represents an expression whose opposite is true.
 * 
 * @author Stephen G. Ware
 */
public class Negation extends BooleanExpression {
	
	/** The expression being negated */
	public final Expression argument;
	
	/**
	 * Constructs a negation of the given argument.
	 * 
	 * @param argument the expression to be negated
	 */
	public Negation(Expression argument) {
		super("not", new Expression[]{ argument });
		this.argument = argument;
	}
	
	@Override
	public String toString() {
		if(argument instanceof NAryBooleanExpression)
			return "\\+(" + argument + ")";
		else
			return "\\+ " + argument;
	}
	
	@Override
	public Negation substitute(Unifier unifier) {
		return new Negation(argument.substitute(unifier));
	}
}
